<?php

try {
    $db = db_connect('default');
    $dbprefix = $db->getPrefix();

    $upgrade_sql = "upgrade-3.1.sql";
    $sql = file_get_contents($upgrade_sql);

    if ($dbprefix) {
        $sql = str_replace('CREATE TABLE IF NOT EXISTS `', 'CREATE TABLE IF NOT EXISTS `' . $dbprefix, $sql);
        $sql = str_replace('INSERT INTO `', 'INSERT INTO `' . $dbprefix, $sql);
        $sql = str_replace('ALTER TABLE `', 'ALTER TABLE `' . $dbprefix, $sql);
        $sql = str_replace('DELETE FROM `', 'DELETE FROM `' . $dbprefix, $sql);
	$sql = str_replace('UPDATE `', 'UPDATE `' . $dbprefix, $sql);
    }

    foreach (explode(";#", $sql) as $query) {
        $query = trim($query);
        if ($query) {
            try {
                $db->query($query);
            } catch (\Exception $ex) {	
		log_message("error", $ex->getTraceAsString());
            }
        }
    }

    unlink($upgrade_sql);
  
    //add company settings data to company table
    $company_name = get_setting("company_name") ? get_setting("company_name") : "";
    $company_address = get_setting("company_address") ? get_setting("company_address") : "";
    $company_phone = get_setting("company_phone") ? get_setting("company_phone") : "";
    $company_email = get_setting("company_email") ? get_setting("company_email") : "";
    $company_website = get_setting("company_website") ? get_setting("company_website") : "";
    $company_vat_number = get_setting("company_vat_number") ? get_setting("company_vat_number") : "";

    $sql_query = "INSERT INTO `" . $dbprefix . "company` 
        (`id`, `name`, `address`, `phone`, `email`, `website`, `vat_number`, `is_default`, `deleted`) VALUES 
        (1, '$company_name', '$company_address', '$company_phone', '$company_email', '$company_website', '$company_vat_number', 1, 0);";

    $db->query($sql_query);

    //remove old company settings data
    $sql_query = "DELETE FROM `" . $dbprefix . "settings` WHERE 
                    `" . $dbprefix . "settings`.`setting_name`='company_name' 
                 OR `" . $dbprefix . "settings`.`setting_name`='company_address' 
                 OR `" . $dbprefix . "settings`.`setting_name`='company_phone' 
                 OR `" . $dbprefix . "settings`.`setting_name`='company_email' 
                 OR `" . $dbprefix . "settings`.`setting_name`='company_website' 
                 OR `" . $dbprefix . "settings`.`setting_name`='company_vat_number' 
                      ;";

    $db->query($sql_query);


} catch (\Exception $exc) {
	log_message("error", $exc->getTraceAsString());
}