ALTER TABLE `leave_applications` ADD `files` TEXT CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL AFTER `checked_by`;#

CREATE TABLE IF NOT EXISTS `task_priority` (
`id` INT NOT NULL AUTO_INCREMENT ,
`title` VARCHAR(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL ,
`icon` VARCHAR(20) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL ,
`color` VARCHAR(7) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL ,
`deleted` TINYINT(1) NOT NULL DEFAULT '0' ,
PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;#

ALTER TABLE `tasks` ADD `priority_id` INT(11) NOT NULL AFTER `status_id`;#

INSERT INTO `task_priority` (`id`, `title`, `icon`, `color`, `deleted`) VALUES
(1, 'Minor', 'arrow-down', '#aab7b7', 0),
(2, 'Major', 'arrow-up', '#e18a00', 0),
(3, 'Critical ', 'alert-circle', '#ad159e', 0),
(4, 'Blocker ', 'alert-octagon', '#e74c3c', 0);#


CREATE TABLE IF NOT EXISTS `company` (
`id` int(11) NOT NULL AUTO_INCREMENT,
`name` text COLLATE utf8_unicode_ci NOT NULL,
`address` text COLLATE utf8_unicode_ci NOT NULL,
`phone` text COLLATE utf8_unicode_ci NOT NULL,
`email` text COLLATE utf8_unicode_ci NOT NULL,
`website` text COLLATE utf8_unicode_ci NOT NULL,
`vat_number` text COLLATE utf8_unicode_ci NOT NULL,
`is_default` tinyint(1) NOT NULL DEFAULT '0',
`deleted` tinyint(1) NOT NULL DEFAULT '0',
PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;#

ALTER TABLE `invoices` ADD `company_id` INT(11) NOT NULL DEFAULT '0' AFTER `deleted`;#

ALTER TABLE `estimates` ADD `company_id` INT(11) NOT NULL DEFAULT '0' AFTER `deleted`;#

ALTER TABLE `contracts` ADD `company_id` INT(11) NOT NULL DEFAULT '0' AFTER `deleted`;#

ALTER TABLE `proposals` ADD `company_id` INT(11) NOT NULL DEFAULT '0' AFTER `deleted`;#

ALTER TABLE `orders` ADD `company_id` INT(11) NOT NULL DEFAULT '0' AFTER `deleted`;#


CREATE TABLE IF NOT EXISTS `checklist_groups` (
`id` int(11) NOT NULL AUTO_INCREMENT,
`title` text COLLATE utf8_unicode_ci NOT NULL,
`checklists` mediumtext COLLATE utf8_unicode_ci NOT NULL,
`deleted` int(1) NOT NULL DEFAULT '0',
PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;#


UPDATE `invoices` SET `company_id` = '1';#

UPDATE `estimates` SET `company_id` = '1';#

UPDATE `contracts` SET `company_id` = '1';#

UPDATE `proposals` SET `company_id` = '1';#

UPDATE `orders` SET `company_id` = '1';#
