<?php

try {
    $db = db_connect('default');
    $dbprefix = $db->getPrefix();

    $upgrade_sql = "upgrade-3.2.sql";
    $sql = file_get_contents($upgrade_sql);

    if ($dbprefix) {
        $sql = str_replace('CREATE TABLE IF NOT EXISTS `', 'CREATE TABLE IF NOT EXISTS `' . $dbprefix, $sql);
        $sql = str_replace('INSERT INTO `', 'INSERT INTO `' . $dbprefix, $sql);
        $sql = str_replace('ALTER TABLE `', 'ALTER TABLE `' . $dbprefix, $sql);
        $sql = str_replace('DELETE FROM `', 'DELETE FROM `' . $dbprefix, $sql);
        $sql = str_replace('UPDATE `', 'UPDATE `' . $dbprefix, $sql);
    }

    foreach (explode(";#", $sql) as $query) {
        $query = trim($query);
        if ($query) {
            try {
                $db->query($query);
            } catch (\Exception $ex) {
                log_message("error", $ex->getTraceAsString());
            }
        }
    }

    unlink($upgrade_sql);

    //store next_recurring_time for recurring events

    $local_time = get_my_local_time("Y-m-d H:i") . ":00";
    $Events_model = model("App\Models\Events_model");

    $events_table = $db->prefixTable('events');

    $event_query = "SELECT $events_table.* FROM $events_table WHERE $events_table.deleted=0 AND $events_table.recurring=1;";
    $recurring_events = $db->query($event_query)->getResult();

    foreach ($recurring_events as $recurring_event) {
        //find the exact next_recurring_time accordint to recurring_dates and start_time
        $recurring_dates_array = explode(',', $recurring_event->recurring_dates);
        foreach ($recurring_dates_array as $recurring_date) {
            if (($recurring_date . " " . $recurring_event->start_time) >= $local_time) {

                //this is the next_recurring_time for this event
                $data = array("next_recurring_time" => $recurring_date . " " . $recurring_event->start_time);
                $Events_model->ci_save($data, $recurring_event->id);

                //break this loop and go to next event
                break;
            }
        }
    }

    //so we've the exact next_recurring_time for recurring events
    //now update the reminder_status
    //set to done for any past events according to main time or next_recurring_time
    $event_query2 = "UPDATE $events_table SET $events_table.reminder_status='done' WHERE 
                ($events_table.recurring=0 AND CONCAT($events_table.start_date, ' ', $events_table.start_time)<'$local_time') OR
                ($events_table.recurring=1 AND CONCAT($events_table.start_date, ' ', $events_table.start_time)<'$local_time' AND ($events_table.next_recurring_time IS NULL OR $events_table.next_recurring_time<'$local_time')) ;";
    $db->query($event_query2);

    //move user langauge from settings to users table. 
    $settings_table = $db->prefixTable('settings');
    $users_table = $db->prefixTable('users');

    $settings_query = "SELECT $settings_table.setting_name, $settings_table.setting_value
                    FROM $settings_table
                    WHERE $settings_table.deleted=0 AND $settings_table.setting_name LIKE '%_personal_language'";

    $user_languages = $db->query($settings_query)->getResult();

    foreach ($user_languages as $user_language) {
        $user_language_setting = $user_language->setting_name;
        $user_language_setting_array = explode("_", $user_language_setting);
        $user_id = get_array_value($user_language_setting_array, 1);

        $user_update_query = "UPDATE $users_table SET $users_table.language = '" . $user_language->setting_value . "' WHERE $users_table.id = $user_id";
        $db->query($user_update_query);
    }

    $contract_items_table = $db->prefixTable('contract_items');
    $estimate_items_table = $db->prefixTable('estimate_items');
    $invoice_items_table = $db->prefixTable('invoice_items');
    $proposal_items_table = $db->prefixTable('proposal_items');
    $items_table = $db->prefixTable('items');

    $db->query(" UPDATE $contract_items_table SET $contract_items_table.item_id = (SELECT $items_table.id FROM $items_table WHERE $contract_items_table.title = $items_table.title LIMIT 1)");
    $db->query(" UPDATE $estimate_items_table SET $estimate_items_table.item_id = (SELECT $items_table.id FROM $items_table WHERE $estimate_items_table.title = $items_table.title LIMIT 1)");
    $db->query(" UPDATE $invoice_items_table SET $invoice_items_table.item_id = (SELECT $items_table.id FROM $items_table WHERE $invoice_items_table.title = $items_table.title LIMIT 1)");
    $db->query(" UPDATE $proposal_items_table SET $proposal_items_table.item_id = (SELECT $items_table.id FROM $items_table WHERE $proposal_items_table.title = $items_table.title LIMIT 1)");
} catch (\Exception $exc) {
    log_message("error", $exc->getTraceAsString());
    echo $exc->getTraceAsString();
}