<?php

try {
    $db = db_connect('default');
    $dbprefix = $db->getPrefix();

    $upgrade_sql = "upgrade-3.4.1.sql";
    $sql = file_get_contents($upgrade_sql);

    if ($dbprefix) {
        $sql = str_replace('CREATE TABLE IF NOT EXISTS `', 'CREATE TABLE IF NOT EXISTS `' . $dbprefix, $sql);
        $sql = str_replace('INSERT INTO `', 'INSERT INTO `' . $dbprefix, $sql);
        $sql = str_replace('ALTER TABLE `', 'ALTER TABLE `' . $dbprefix, $sql);
        $sql = str_replace('DELETE FROM `', 'DELETE FROM `' . $dbprefix, $sql);
	$sql = str_replace('UPDATE `', 'UPDATE `' . $dbprefix, $sql);
    }

    foreach (explode(";#", $sql) as $query) {
        $query = trim($query);
        if ($query) {
            try {
                $db->query($query);
            } catch (\Exception $ex) {	
		log_message("error", $ex->getTraceAsString());
            }
        }
    }

    unlink($upgrade_sql);


} catch (\Exception $exc) {
	log_message("error", $exc->getTraceAsString());
}