ALTER TABLE `clients` CHANGE `gst_number` `gst_number` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci;#

ALTER TABLE `clients` CHANGE `stripe_customer_id` `stripe_customer_id` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL;#

ALTER TABLE `clients` ADD `labels` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci;#

ALTER TABLE `contracts` CHANGE `meta_data` `meta_data` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL;#

ALTER TABLE `dashboards` CHANGE `color` `color` varchar(15) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL;#

ALTER TABLE `events` ADD `proposal_id` int NOT NULL DEFAULT '0';#

ALTER TABLE `events` ADD `contract_id` int NOT NULL DEFAULT '0';#

ALTER TABLE `events` ADD `subscription_id` int NOT NULL DEFAULT '0';#

ALTER TABLE `events` ADD `invoice_id` int NOT NULL DEFAULT '0';#

ALTER TABLE `events` ADD `order_id` int NOT NULL DEFAULT '0';#

ALTER TABLE `events` ADD `estimate_id` int NOT NULL DEFAULT '0';#

ALTER TABLE `help_articles` CHANGE `status` `status` enum('active','inactive') CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'active';#

ALTER TABLE `help_categories` ADD `articles_order` varchar(3) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '';#

ALTER TABLE `help_categories` CHANGE `status` `status` enum('active','inactive') CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'active';#

ALTER TABLE `invoices` ADD `type` enum('invoice','credit_note') CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'invoice';#

ALTER TABLE `invoices` CHANGE `status` `status` enum('draft','not_paid','cancelled','credited') CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'draft';#

ALTER TABLE `invoices` ADD `main_invoice_id` int NOT NULL DEFAULT '0';#

ALTER TABLE `invoices` ADD `invoice_total` double NOT NULL;#

ALTER TABLE `invoices` ADD `invoice_subtotal` double NOT NULL;#

ALTER TABLE `invoices` ADD `discount_total` double NOT NULL;#

ALTER TABLE `invoices` ADD `tax` double NOT NULL;#

ALTER TABLE `invoices` ADD `tax2` double NOT NULL;#

ALTER TABLE `invoices` ADD `tax3` double NOT NULL;#

ALTER TABLE `invoices` ADD `order_id` int NOT NULL DEFAULT '0';#

ALTER TABLE `invoice_items` ADD `taxable` tinyint(1) NOT NULL DEFAULT '1';#

ALTER TABLE `items` ADD `taxable` tinyint(1) NOT NULL DEFAULT '0';#

ALTER TABLE `labels` CHANGE `color` `color` varchar(15) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL;#

ALTER TABLE `labels` CHANGE `context` `context` enum('event','invoice','note','project','task','ticket','to_do','subscription','client') CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL;#

ALTER TABLE `notifications` ADD `expense_id` int NOT NULL;#

ALTER TABLE `orders` ADD `created_by_hash` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL;#

ALTER TABLE `order_items` ADD `created_by_hash` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL;#

ALTER TABLE `pages` ADD `full_width` tinyint(1) NOT NULL DEFAULT '0';#

ALTER TABLE `pages` ADD `hide_topbar` tinyint(1) NOT NULL DEFAULT '0';#

ALTER TABLE `paypal_ipn` CHANGE `verification_code` `verification_code` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL;#

ALTER TABLE `paypal_ipn` CHANGE `payment_verification_code` `payment_verification_code` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL;#

ALTER TABLE `projects` ADD `status_id` int NOT NULL DEFAULT '1';#

DROP TABLE IF EXISTS `project_status`;
CREATE TABLE IF NOT EXISTS `project_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `title_language_key` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `key_name` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `icon` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `deleted` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

ALTER TABLE `proposals` CHANGE `meta_data` `meta_data` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL;#

ALTER TABLE `stripe_ipn` CHANGE `session_id` `session_id` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL;#

ALTER TABLE `stripe_ipn` CHANGE `verification_code` `verification_code` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL;#

ALTER TABLE `stripe_ipn` CHANGE `payment_verification_code` `payment_verification_code` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL;#

ALTER TABLE `stripe_ipn` CHANGE `setup_intent` `setup_intent` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL;#

ALTER TABLE `subscriptions` CHANGE `status` `status` enum('draft','pending','active','cancelled') CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'draft';#

ALTER TABLE `subscriptions` CHANGE `payment_status` `payment_status` enum('success','failed') CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'success';#

ALTER TABLE `subscriptions` CHANGE `repeat_type` `repeat_type` enum('days','weeks','months','years') CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL;#

ALTER TABLE `subscriptions` CHANGE `type` `type` enum('app','stripe') CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'app';#

ALTER TABLE `subscriptions` CHANGE `stripe_subscription_id` `stripe_subscription_id` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL;#

ALTER TABLE `subscriptions` CHANGE `stripe_product_id` `stripe_product_id` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL;#

ALTER TABLE `subscriptions` CHANGE `stripe_product_price_id` `stripe_product_price_id` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL;#

ALTER TABLE `tasks` CHANGE `deadline` `deadline` datetime DEFAULT NULL;#

ALTER TABLE `tasks` CHANGE `start_date` `start_date` datetime DEFAULT NULL;#

ALTER TABLE `tasks` CHANGE `created_date` `created_date` date DEFAULT NULL;#

ALTER TABLE `tasks` CHANGE `reminder_date` `reminder_date` date DEFAULT NULL;#

ALTER TABLE `tasks` ADD `expense_id` int NOT NULL DEFAULT '0';#

ALTER TABLE `tasks` ADD `subscription_id` int NOT NULL DEFAULT '0';#

ALTER TABLE `tasks` ADD `proposal_id` int NOT NULL DEFAULT '0';#

ALTER TABLE `tasks` ADD `contract_id` int NOT NULL DEFAULT '0';#

ALTER TABLE `tasks` ADD `order_id` int NOT NULL DEFAULT '0';#

ALTER TABLE `tasks` ADD `estimate_id` int NOT NULL DEFAULT '0';#

ALTER TABLE `tasks` ADD `invoice_id` int NOT NULL DEFAULT '0';#

ALTER TABLE `tasks` ADD `lead_id` int NOT NULL DEFAULT '0';#

ALTER TABLE `tasks` ADD `client_id` int NOT NULL DEFAULT '0';#

ALTER TABLE `tasks` ADD `context` enum('project','client','lead','invoice','estimate','order','contract','proposal','subscription','ticket','expense') CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'project';#

ALTER TABLE `task_status` ADD `hide_from_non_project_related_tasks` tinyint(1) NOT NULL DEFAULT '0';#

