<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 72.
namespace App\Controllers;

class Security_Controller extends App_Controller
{
    public $login_user;
    protected $access_type = "";
    protected $allowed_members = [];
    protected $allowed_ticket_types = [];
    protected $allowed_client_groups = [];
    protected $module_group = "";
    protected $is_user_a_project_member = false;
    protected $is_clients_project = false;
    public function __construct($redirect = true)
    {
        parent::__construct();
        $login_user_id = $this->Users_model->login_user_id();
        if(!$login_user_id && $redirect) {
            $uri_string = uri_string();
            if(!$uri_string || $uri_string === "signin" || $uri_string === "/signin" || $uri_string === "/") {
                app_redirect("signin");
            } else {
                app_redirect("signin?redirect=" . get_uri($uri_string));
            }
        }
        app_hooks()->do_action("app_hook_before_app_access", ["login_user_id" => $login_user_id, "redirect" => $redirect]);
        $this->login_user = $this->Users_model->get_access_info($login_user_id);
        if($this->login_user && $this->login_user->permissions) {
            $permissions = unserialize($this->login_user->permissions);
            $this->login_user->permissions = is_array($permissions) ? $permissions : [];
        } else {
            if(!$this->login_user) {
                $this->login_user = new \stdClass();
            }
            $this->login_user->permissions = [];
        }
    }
    protected function init_permission_checker($module)
    {
        $info = $this->get_access_info($module);
        $this->access_type = $info->access_type;
        $this->allowed_members = $info->allowed_members;
        $this->allowed_ticket_types = $info->allowed_ticket_types;
        $this->allowed_client_groups = $info->allowed_client_groups;
        $this->module_group = $info->module_group;
    }
    protected function get_access_info($group)
    {
        $info = new \stdClass();
        $info->access_type = "";
        $info->allowed_members = [];
        $info->allowed_ticket_types = [];
        $info->allowed_client_groups = [];
        $info->module_group = $group;
        if($this->login_user->is_admin) {
            $info->access_type = "all";
        } else {
            $module_permission = get_array_value($this->login_user->permissions, $group);
            if($module_permission === "all") {
                $info->access_type = "all";
            } elseif($module_permission === "specific" || $module_permission === "specific_excluding_own") {
                $info->access_type = "specific";
                $module_permission = get_array_value($this->login_user->permissions, $group . "_specific");
                $permissions = explode(",", $module_permission);
                if($group === "leave" || $group === "attendance" || $group === "team_member_update_permission" || $group === "timesheet_manage_permission" || $group == "message_permission" || $group == "timeline_permission") {
                    $info->allowed_members = prepare_allowed_members_array($permissions, $this->login_user->id);
                } elseif($group === "ticket") {
                    $info->allowed_ticket_types = $permissions;
                } elseif($group === "client") {
                    $info->allowed_client_groups = $permissions;
                }
            } elseif($module_permission === "own" || $module_permission === "read_only" || $module_permission === "assigned_only" || $module_permission === "own_project_members" || $module_permission === "own_project_members_excluding_own") {
                $info->access_type = $module_permission;
            }
        }
        return $info;
    }
    protected function access_only_team_members()
    {
        if($this->login_user->user_type !== "staff") {
            app_redirect("forbidden");
        }
    }
    protected function access_only_admin()
    {
        if(!$this->login_user->is_admin) {
            app_redirect("forbidden");
        }
    }
    protected function access_only_admin_or_settings_admin()
    {
        if(!($this->login_user->is_admin || get_array_value($this->login_user->permissions, "can_manage_all_kinds_of_settings"))) {
            app_redirect("forbidden");
        }
    }
    protected function access_only_allowed_members()
    {
        if($this->access_type === "all") {
            return true;
        }
        if($this->module_group === "ticket" && ($this->access_type === "specific" || $this->access_type === "assigned_only")) {
            return true;
        }
        if($this->module_group === "lead" && $this->access_type === "own") {
            return true;
        }
        if($this->module_group === "client" && ($this->access_type === "own" || $this->access_type === "read_only" || $this->access_type === "specific")) {
            return true;
        }
        if($this->module_group === "estimate" && $this->access_type === "own") {
            return true;
        }
        app_redirect("forbidden");
    }
    protected function access_only_allowed_members_or_client_contact($client_id)
    {
        if($this->access_type === "all") {
            return true;
        }
        if($this->module_group === "ticket" && ($this->access_type === "specific" || $this->access_type === "assigned_only")) {
            return true;
        }
        if($this->module_group === "client" && ($this->access_type === "own" || $this->access_type === "read_only" || $this->access_type === "specific")) {
            return true;
        }
        if($this->login_user->client_id === $client_id) {
            return true;
        }
        if($this->module_group === "estimate" && $this->access_type === "own") {
            return true;
        }
        app_redirect("forbidden");
    }
    protected function access_only_allowed_members_or_contact_personally($user_id)
    {
        if(!($this->access_type === "all" || $this->access_type === "own" || $this->access_type === "read_only" || $user_id === $this->login_user->id)) {
            app_redirect("forbidden");
        }
    }
    protected function access_only_team_members_or_client_contact($client_id)
    {
        if(!($this->login_user->user_type === "staff" || $this->login_user->client_id === $client_id)) {
            app_redirect("forbidden");
        }
    }
    protected function access_only_clients()
    {
        if($this->login_user->user_type != "client") {
            app_redirect("forbidden");
        }
    }
    protected function check_module_availability($module_name)
    {
        if(get_setting($module_name) != "1") {
            app_redirect("forbidden");
        }
    }
    protected function can_create_projects()
    {
        if($this->login_user->user_type == "staff") {
            if($this->login_user->is_admin || get_array_value($this->login_user->permissions, "can_manage_all_projects") == "1") {
                return true;
            }
            if(get_array_value($this->login_user->permissions, "can_create_projects") == "1") {
                return true;
            }
        } elseif(get_setting("client_can_create_projects")) {
            return true;
        }
    }
    protected function can_view_team_members_list()
    {
        if($this->login_user->user_type == "staff") {
            if(get_array_value($this->login_user->permissions, "hide_team_members_list") == "1") {
                return false;
            }
            return true;
        }
        return false;
    }
    protected function access_only_team_members_or_client()
    {
        if(!($this->login_user->user_type === "staff" || $this->login_user->user_type === "client")) {
            app_redirect("forbidden");
        }
    }
    protected function init_project_permission_checker($project_id = 0)
    {
        if(!$project_id) {
            return false;
        }
        if($this->login_user->user_type == "client") {
            $project_info = $this->Projects_model->get_one($project_id);
            if($project_info->client_id == $this->login_user->client_id) {
                $this->is_clients_project = true;
            }
        } else {
            $this->is_user_a_project_member = $this->Project_members_model->is_user_a_project_member($project_id, $this->login_user->id);
        }
    }
    protected function can_manage_all_projects()
    {
        if($this->login_user->is_admin || get_array_value($this->login_user->permissions, "can_manage_all_projects") == "1") {
            return true;
        }
    }
    protected function _get_currencies_dropdown($support_empty_value = true)
    {
        $used_currencies = $this->Invoices_model->get_used_currencies_of_client()->getResult();
        $default_currency = get_setting("default_currency");
        $currencies_dropdown = [];
        if($support_empty_value) {
            $currencies_dropdown[] = ["id" => "", "text" => "- " . app_lang("currency") . " -"];
        }
        $currencies_dropdown[] = ["id" => $default_currency, "text" => $default_currency];
        if($used_currencies) {
            foreach ($used_currencies as $currency) {
                $currencies_dropdown[] = ["id" => $currency->currency, "text" => $currency->currency];
            }
        }
        return json_encode($currencies_dropdown);
    }
    protected function get_hidden_topbar_menus_dropdown()
    {
        $hidden_topbar_menus = ["to_do", "favorite_projects", "dashboard_customization", "quick_add"];
        if($this->login_user->user_type == "staff") {
            $access_client = get_array_value($this->login_user->permissions, "client");
            if($this->login_user->is_admin || $access_client) {
                array_push($hidden_topbar_menus, "favorite_clients");
            }
            if(!get_setting("disable_language_selector_for_team_members")) {
                array_push($hidden_topbar_menus, "language");
            }
        } elseif(!get_setting("disable_language_selector_for_clients")) {
            array_push($hidden_topbar_menus, "language");
        }
        $hidden_topbar_menus_dropdown = [];
        foreach ($hidden_topbar_menus as $hidden_menu) {
            $hidden_topbar_menus_dropdown[] = ["id" => $hidden_menu, "text" => app_lang($hidden_menu)];
        }
        return json_encode($hidden_topbar_menus_dropdown);
    }
    protected function _get_projects_dropdown_for_income_and_expenses($type = "all")
    {
        $projects = $this->Invoice_payments_model->get_used_projects($type)->getResult();
        if($projects) {
            $projects_dropdown = [["id" => "", "text" => "- " . app_lang("project") . " -"]];
            foreach ($projects as $project) {
                $projects_dropdown[] = ["id" => $project->id, "text" => $project->title];
            }
            return json_encode($projects_dropdown);
        }
    }
    protected function _get_groups_dropdown_select2_data($show_header = false)
    {
        $client_groups = $this->Client_groups_model->get_all()->getResult();
        $groups_dropdown = [];
        if($show_header) {
            $groups_dropdown[] = ["id" => "", "text" => "- " . app_lang("client_groups") . " -"];
        }
        foreach ($client_groups as $group) {
            $groups_dropdown[] = ["id" => $group->id, "text" => $group->title];
        }
        return $groups_dropdown;
    }
    protected function get_clients_and_leads_dropdown($return_json = false)
    {
        $clients_dropdown = ["" => "-"];
        $clients_json_dropdown = [["id" => "", "text" => "-"]];
        $clients = $this->Clients_model->get_all_where(["deleted" => 0], 0, 0, "is_lead")->getResult();
        foreach ($clients as $client) {
            $company_name = $client->is_lead ? app_lang("lead") . ": " . $client->company_name : $client->company_name;
            $clients_dropdown[$client->id] = $company_name;
            $clients_json_dropdown[] = ["id" => $client->id, "text" => $company_name];
        }
        return $return_json ? $clients_json_dropdown : $clients_dropdown;
    }
    protected function show_assigned_tasks_only_user_id()
    {
        if($this->login_user->user_type === "staff") {
            return get_array_value($this->login_user->permissions, "show_assigned_tasks_only") == "1" ? $this->login_user->id : false;
        }
    }
    protected function get_calendar_filter_dropdown($type = "default")
    {
        helper("cookie");
        $selected_filters_cookie = get_cookie("calendar_filters_of_user_" . $this->login_user->id);
        $selected_filters_cookie_array = $selected_filters_cookie ? explode("-", $selected_filters_cookie) : ["events"];
        $calendar_filter_dropdown = [["id" => "events", "text" => app_lang("events"), "isChecked" => in_array("events", $selected_filters_cookie_array) ? true : false]];
        if($type !== "lead") {
            if($this->login_user->user_type == "staff" && $type == "default") {
                $leave_access_info = $this->get_access_info("leave");
                if($leave_access_info->access_type && get_setting("module_leave")) {
                    $calendar_filter_dropdown[] = ["id" => "leave", "text" => app_lang("leave"), "isChecked" => in_array("leave", $selected_filters_cookie_array) ? true : false];
                }
                $calendar_filter_dropdown[] = ["id" => "task_start_date", "text" => app_lang("task_start_date"), "isChecked" => in_array("task_start_date", $selected_filters_cookie_array) ? true : false];
                $calendar_filter_dropdown[] = ["id" => "task_deadline", "text" => app_lang("task_deadline"), "isChecked" => in_array("task_deadline", $selected_filters_cookie_array) ? true : false];
            }
            $calendar_filter_dropdown[] = ["id" => "project_start_date", "text" => app_lang("project_start_date"), "isChecked" => in_array("project_start_date", $selected_filters_cookie_array) ? true : false];
            $calendar_filter_dropdown[] = ["id" => "project_deadline", "text" => app_lang("project_deadline"), "isChecked" => in_array("project_deadline", $selected_filters_cookie_array) ? true : false];
        }
        return $calendar_filter_dropdown;
    }
    protected function check_access_to_store()
    {
        $this->check_module_availability("module_order");
        if(isset($this->login_user->id)) {
            if($this->login_user->user_type == "staff") {
                $this->access_only_allowed_members();
            } elseif(!get_setting("client_can_access_store")) {
                app_redirect("forbidden");
            }
        } elseif(!(get_setting("module_order") && get_setting("visitors_can_see_store_before_login"))) {
            app_redirect("forbidden");
        }
    }
    protected function check_access_to_this_order_item($order_item_info)
    {
        if($order_item_info->id) {
            if(!$order_item_info->order_id) {
                if($order_item_info->created_by !== $this->login_user->id) {
                    app_redirect("forbidden");
                }
            } elseif($this->login_user->user_type == "client") {
                app_redirect("forbidden");
            }
        } elseif($this->login_user->user_type !== "staff") {
            app_redirect("forbidden");
        }
    }
    protected function make_labels_dropdown($type = "", $label_ids = "", $is_filter = false, $custom_filter_title = "")
    {
        if(!$type) {
            show_404();
        }
        $labels_dropdown = $is_filter ? [["id" => "", "text" => "- " . ($custom_filter_title ? $custom_filter_title : app_lang("label")) . " -"]] : [];
        $options = ["context" => $type];
        if($type == "event" || $type == "note" || $type == "to_do") {
            $options["user_id"] = $this->login_user->id;
        }
        if($label_ids) {
            $add_label_option = true;
            $explode_ids = explode(",", $label_ids);
            foreach ($explode_ids as $label_id) {
                if(!is_int($label_id)) {
                    $add_label_option = false;
                    if($add_label_option) {
                        $options["label_ids"] = $label_ids;
                    }
                }
            }
        }
        $labels = $this->Labels_model->get_details($options)->getResult();
        foreach ($labels as $label) {
            $labels_dropdown[] = ["id" => $label->id, "text" => $label->title];
        }
        return $labels_dropdown;
    }
    protected function can_edit_projects($project_id = 0)
    {
        if($this->login_user->user_type == "staff") {
            if($this->can_manage_all_projects()) {
                return true;
            }
            $can_edit_projects = get_array_value($this->login_user->permissions, "can_edit_projects");
            $can_edit_only_own_created_projects = get_array_value($this->login_user->permissions, "can_edit_only_own_created_projects");
            if($can_edit_projects) {
                return true;
            }
            if($project_id) {
                $project_info = $this->Projects_model->get_one($project_id);
                if($can_edit_only_own_created_projects && $project_info->created_by === $this->login_user->id) {
                    return true;
                }
            } elseif($can_edit_only_own_created_projects) {
                return true;
            }
        } elseif(get_setting("client_can_edit_projects")) {
            return true;
        }
    }
    protected function get_user_options_for_query($only_type = "")
    {
        $options = ["login_user_id" => $this->login_user->id];
        $client_message_users = get_setting("client_message_users");
        if($this->login_user->user_type == "staff") {
            if($only_type !== "client") {
                if(!get_array_value($this->login_user->permissions, "message_permission")) {
                    $options["all_members"] = true;
                } elseif(get_array_value($this->login_user->permissions, "message_permission") == "specific") {
                    $options["specific_members"] = $this->allowed_members;
                }
            }
            $client_message_users_array = explode(",", $client_message_users);
            if(in_array($this->login_user->id, $client_message_users_array) && $only_type !== "staff") {
                $options["member_to_clients"] = true;
            }
        } elseif($client_message_users) {
            if($only_type !== "client") {
                $options["client_to_members"] = $client_message_users;
            }
            if(get_setting("client_message_own_contacts") && $only_type !== "staff") {
                $options["client_id"] = $this->login_user->client_id;
            }
        }
        return $options;
    }
    protected function check_access_on_messages_for_this_user()
    {
        $accessable = true;
        if($this->login_user->user_type == "staff") {
            $client_message_users = get_setting("client_message_users");
            $client_message_users_array = explode(",", $client_message_users);
            if(!$this->login_user->is_admin && get_array_value($this->login_user->permissions, "message_permission") == "no" && !in_array($this->login_user->id, $client_message_users_array)) {
                $accessable = false;
            }
        } elseif(!get_setting("client_message_users")) {
            $accessable = false;
        }
        return $accessable;
    }
    protected function can_view_invoices($client_id = 0)
    {
        if($this->login_user->user_type == "staff") {
            if($this->login_user->is_admin || get_array_value($this->login_user->permissions, "invoice") === "all" || get_array_value($this->login_user->permissions, "invoice") === "read_only") {
                return true;
            }
        } elseif($this->login_user->client_id === $client_id) {
            return true;
        }
    }
    protected function can_edit_invoices()
    {
        if($this->login_user->user_type == "staff" && ($this->login_user->is_admin || get_array_value($this->login_user->permissions, "invoice") === "all")) {
            return true;
        }
    }
    protected function can_access_expenses()
    {
        $permissions = $this->login_user->permissions;
        if($this->login_user->is_admin || get_array_value($permissions, "expense")) {
            return true;
        }
        return false;
    }
    protected function validate_sending_message($to_user_id)
    {
        $users = $this->Messages_model->get_users_for_messaging($this->get_user_options_for_query())->getResult();
        $users = json_decode(json_encode($users), true);
        if(!$this->check_access_on_messages_for_this_user() || !in_array($to_user_id, array_column($users, "id"))) {
            return false;
        }
        $to_user_info = $this->Users_model->get_one($to_user_id);
        if($to_user_info->user_type == "staff") {
            $permissions = [];
            $user_permissions = $this->Users_model->get_access_info($to_user_id)->permissions;
            if($user_permissions) {
                $user_permissions = unserialize($user_permissions);
                $permissions = is_array($user_permissions) ? $user_permissions : [];
            }
            if(get_array_value($permissions, "message_permission") == "no") {
                return false;
            }
            if(get_array_value($permissions, "message_permission") == "specific") {
                $module_permission = get_array_value($permissions, "message_permission_specific");
                $permissions = explode(",", $module_permission);
                $allowed_members = prepare_allowed_members_array($permissions, $to_user_id);
                if(!in_array($this->login_user->id, $allowed_members)) {
                    return false;
                }
            }
        }
        return true;
    }
    protected function show_own_clients_only_user_id()
    {
        if($this->login_user->user_type === "staff") {
            return get_array_value($this->login_user->permissions, "client") == "own" ? $this->login_user->id : false;
        }
    }
    protected function check_profile_image_dimension($image_file_name = "")
    {
        if(!$image_file_name) {
            return false;
        }
        list($width, $height) = getimagesize($image_file_name);
        if($width === 200 && $height === 200) {
            return true;
        }
        return false;
    }
    protected function show_assigned_tickets_only_user_id()
    {
        if($this->access_type === "assigned_only") {
            return $this->login_user->id;
        }
    }
    protected function get_team_members_dropdown($is_filter = false)
    {
        $team_members = $this->Users_model->get_all_where(["user_type" => "staff", "deleted" => 0, "status" => "active"])->getResult();
        $team_members_dropdown = [];
        if($is_filter) {
            $team_members_dropdown = [["id" => "", "text" => "- " . app_lang("owner") . " -"]];
        }
        foreach ($team_members as $member) {
            $team_members_dropdown[] = ["id" => $member->id, "text" => $member->first_name . " " . $member->last_name];
        }
        return json_encode($team_members_dropdown);
    }
    protected function _get_projects_dropdown()
    {
        $project_options = ["status_id" => 1];
        if($this->login_user->user_type == "staff") {
            if(!$this->can_manage_all_projects()) {
                $project_options["user_id"] = $this->login_user->id;
            }
        } else {
            $project_options["client_id"] = $this->login_user->client_id;
        }
        $projects = $this->Projects_model->get_details($project_options)->getResult();
        $projects_dropdown = ["" => "-"];
        if($projects) {
            foreach ($projects as $project) {
                $projects_dropdown[$project->id] = $project->title;
            }
        }
        return $projects_dropdown;
    }
    protected function check_access_to_this_item($item_info)
    {
        if($this->login_user->user_type === "client" && !$item_info->show_in_client_portal) {
            app_redirect("forbidden");
        }
    }
    protected function get_conversion_rate_with_currency_symbol()
    {
        $symbol_array = [];
        $conversion_rate = get_setting("conversion_rate");
        $conversion_rate = @unserialize($conversion_rate);
        if(!($conversion_rate && is_array($conversion_rate) && count($conversion_rate))) {
            return json_encode($symbol_array);
        }
        $clients = $this->Clients_model->get_conversion_rate_with_currency_symbol()->getResult();
        foreach ($clients as $client) {
            $rate_for_this_currency = get_array_value($conversion_rate, $client->currency);
            if($rate_for_this_currency) {
                $symbol_array[$client->currency_symbol] = $rate_for_this_currency;
            }
        }
        return json_encode($symbol_array);
    }
    protected function can_edit_clients($client_id = 0)
    {
        $permissions = $this->login_user->permissions;
        if($this->login_user->is_admin) {
            return true;
        }
        if(get_array_value($permissions, "client") == "all") {
            return true;
        }
        if(!$client_id && $this->login_user->user_type == "staff" && get_array_value($permissions, "client") === "read_only") {
            return false;
        }
        if(!$client_id && get_array_value($permissions, "client")) {
            return true;
        }
        if($client_id) {
            $client_info = $this->Clients_model->get_one($client_id);
            if($this->login_user->user_type == "client" && $client_info->id === $this->login_user->client_id) {
                return true;
            }
            if(get_array_value($permissions, "client") === "own" && ($client_info->created_by == $this->login_user->id || $client_info->owner_id == $this->login_user->id)) {
                return true;
            }
            if(get_array_value($permissions, "client") === "specific") {
                $specific_client_groups = explode(",", get_array_value($permissions, "client_specific"));
                if(array_intersect($specific_client_groups, explode(",", $client_info->group_ids))) {
                    return true;
                }
            }
        }
    }
    protected function can_view_clients($client_id = 0)
    {
        if($this->can_edit_clients($client_id)) {
            return true;
        }
        if(get_array_value($this->login_user->permissions, "client") === "read_only") {
            return true;
        }
    }
    protected function can_access_tickets($ticket_id = 0)
    {
        $permissions = $this->login_user->permissions;
        if($this->login_user->is_admin) {
            return true;
        }
        if(get_array_value($permissions, "ticket") == "all") {
            return true;
        }
        if(!$ticket_id && get_array_value($permissions, "ticket") || $this->login_user->user_type == "client") {
            return true;
        }
        if($ticket_id) {
            $ticket_info = $this->Tickets_model->get_one($ticket_id);
            if($this->login_user->user_type == "client" && $ticket_info->client_id === $this->login_user->client_id) {
                return true;
            }
            if(get_array_value($permissions, "ticket") === "assigned_only" && $ticket_info->assigned_to == $this->login_user->id) {
                return true;
            }
            if(get_array_value($permissions, "ticket") === "specific") {
                $allowed_ticket_types = explode(",", get_array_value($permissions, "ticket_specific"));
                if(in_array($ticket_info->ticket_type_id, $allowed_ticket_types)) {
                    return true;
                }
            }
        }
    }
    protected function can_access_this_lead($lead_id = 0)
    {
        $permissions = $this->login_user->permissions;
        if($this->login_user->is_admin) {
            return true;
        }
        if(get_array_value($permissions, "lead") == "all") {
            return true;
        }
        if(!$lead_id && get_array_value($permissions, "lead")) {
            return true;
        }
        if($lead_id) {
            $lead_info = $this->Clients_model->get_one($lead_id);
            if($lead_info->id && get_array_value($permissions, "lead") == "own" && $lead_info->owner_id == $this->login_user->id) {
                return true;
            }
        }
    }
    protected function show_own_leads_only_user_id()
    {
        if($this->login_user->user_type === "staff") {
            return get_array_value($this->login_user->permissions, "lead") == "own" ? $this->login_user->id : false;
        }
    }
    protected function prepare_custom_field_filter_values($related_to, $is_admin = 0, $user_type = "")
    {
        $custom_fields_for_filter = $this->Custom_fields_model->get_available_filters($related_to, $is_admin, $user_type);
        $data = [];
        foreach ($custom_fields_for_filter as $column) {
            if($this->request->getPost("custom_field_filter_" . $column->id)) {
                $data[$column->id] = $this->request->getPost("custom_field_filter_" . $column->id);
            }
        }
        return $data;
    }
    protected function _get_roles_dropdown()
    {
        $role_dropdown = [app_lang("team_member")];
        if($this->login_user->is_admin) {
            $role_dropdown["admin"] = app_lang("admin");
        }
        $roles = $this->Roles_model->get_all()->getResult();
        foreach ($roles as $role) {
            $role_dropdown[$role->id] = $role->title;
        }
        return $role_dropdown;
    }
    protected function is_own_id($user_id)
    {
        return $this->login_user->id === $user_id;
    }
    protected function has_role_manage_permission()
    {
        return get_array_value($this->login_user->permissions, "can_manage_user_role_and_permissions");
    }
    protected function is_admin_role($role)
    {
        return $role == "admin";
    }
    public function get_allowed_user_ids()
    {
        $users = $this->Messages_model->get_users_for_messaging($this->get_user_options_for_query())->getResult();
        $users = json_decode(json_encode($users), true);
        return implode(",", array_column($users, "id"));
    }
    protected function _check_valid_date($string = "")
    {
        try {
            if(strtotime($string)) {
            } elseif(strtotime($modified_string = str_replace("-", "/", $string))) {
                $string = $modified_string;
            } elseif(strtotime($modified_string = str_replace("/", "-", $string))) {
                $string = $modified_string;
            } elseif(strtotime($modified_string = str_replace(".", "/", $string))) {
                $string = $modified_string;
            } else {
                return false;
            }
        } catch (\Exception $ex) {
            return false;
        }
        return date("Y-m-d", strtotime($string));
    }
    protected function has_all_projects_restricted_role()
    {
        if($this->login_user->user_type === "staff" && !$this->login_user->is_admin && get_array_value($this->login_user->permissions, "do_not_show_projects") == "1") {
            return true;
        }
    }
    protected function _get_companies_dropdown()
    {
        $Company_model = model("App\\Models\\Company_model");
        $companies = $Company_model->get_details()->getResult();
        $companies_dropdown = [];
        foreach ($companies as $company) {
            $companies_dropdown[] = ["id" => $company->id, "text" => $company->name];
        }
        return $companies_dropdown;
    }
    protected function _make_order_item_row($data)
    {
        $item = "<div class='item-row strong mb5' data-id='" . $data->id . "'><div class='float-start move-icon'><i data-feather='menu' class='icon-16'></i></div> " . $data->title . "</div>";
        if($data->description) {
            $item .= "<span>" . nl2br($data->description) . "</span>";
        }
        $type = $data->unit_type ? $data->unit_type : "";
        return [$data->sort, $item, to_decimal_format($data->quantity) . " " . $type, to_currency($data->rate), to_currency($data->total), modal_anchor(get_uri("store/item_modal_form"), "<i data-feather='edit' class='icon-16'></i>", ["class" => "edit", "title" => app_lang("edit_item"), "data-post-id" => $data->id, "data-post-order_id" => $data->order_id]) . js_anchor("<i data-feather='x' class='icon-16'></i>", ["title" => app_lang("delete"), "class" => "delete", "data-id" => $data->id, "data-action-url" => get_uri("store/delete_item"), "data-action" => "delete"])];
    }
    protected function can_view_subscriptions($client_id = 0)
    {
        if($this->login_user->user_type == "staff") {
            if($this->login_user->is_admin || get_array_value($this->login_user->permissions, "subscription")) {
                return true;
            }
        } elseif($this->login_user->client_id === $client_id) {
            return true;
        }
    }
    protected function can_edit_subscriptions($subscription_id = 0)
    {
        $permissions = $this->login_user->permissions;
        if($this->login_user->is_admin) {
            return true;
        }
        if(get_array_value($permissions, "subscription") == "all") {
            return true;
        }
        if(!$subscription_id && $this->login_user->user_type == "staff" && get_array_value($permissions, "subscription") === "read_only") {
            return false;
        }
        if($subscription_id) {
            $subscription_info = $this->Subscriptions_model->get_one($subscription_id);
            if($this->login_user->user_type == "staff" && get_array_value($permissions, "subscription") !== "read_only" && $subscription_info->status !== "active") {
                return true;
            }
        }
    }
    protected function can_access_team_members_note($user_id)
    {
        if(($this->login_user->is_admin || get_array_value($this->login_user->permissions, "team_members_note_manage_permission")) && $user_id != $this->login_user->id) {
            return true;
        }
    }
    protected function _get_members_to_manage_timesheet()
    {
        $access_info = $this->get_access_info("timesheet_manage_permission");
        $access_type = $access_info->access_type;
        if(!$access_type || $access_type === "own") {
            return [$this->login_user->id];
        }
        if(($access_type === "specific" || $access_type === "specific_excluding_own") && count($access_info->allowed_members)) {
            return $access_info->allowed_members;
        }
        return $access_type;
    }
    protected function init_project_settings($project_id)
    {
        if(!$project_id) {
            return false;
        }
        $settings = $this->Project_settings_model->get_all_where(["project_id" => $project_id])->getResult();
        foreach ($settings as $setting) {
            config("Rise")->app_settings_array[$setting->setting_name] = $setting->setting_value;
        }
    }
    protected function can_view_timesheet($project_id = 0, $show_all_personal_timesheets = false)
    {
        if(!get_setting("module_project_timesheet")) {
            return false;
        }
        if($this->login_user->user_type == "staff") {
            if($this->can_manage_all_projects()) {
                return true;
            }
            if($project_id) {
                $this->init_project_permission_checker($project_id);
                return $this->is_user_a_project_member;
            }
            $access_info = $this->get_access_info("timesheet_manage_permission");
            if($access_info->access_type) {
                return true;
            }
            if(count($access_info->allowed_members)) {
                return true;
            }
            if($show_all_personal_timesheets) {
                return true;
            }
        } elseif(get_setting("client_can_view_timesheet")) {
            return $this->is_clients_project;
        }
    }
    protected function can_access_clients($is_task = false)
    {
        $permissions = $this->login_user->permissions;
        if($is_task) {
            if(get_setting("client_can_view_tasks") && ($this->login_user->is_admin || $this->login_user->user_type == "staff" && get_array_value($permissions, "client") && get_array_value($permissions, "show_assigned_tasks_only") !== "1")) {
                return true;
            }
        } elseif($this->login_user->is_admin || get_array_value($permissions, "client")) {
            return true;
        }
    }
    protected function can_view_milestones()
    {
        if($this->login_user->user_type == "staff") {
            if($this->can_manage_all_projects()) {
                return true;
            }
            return $this->is_user_a_project_member;
        }
        if(get_setting("client_can_view_milestones")) {
            return $this->is_clients_project;
        }
    }
    protected function show_own_estimates_only_user_id()
    {
        if($this->login_user->user_type === "staff") {
            return get_array_value($this->login_user->permissions, "estimate") == "own" ? $this->login_user->id : false;
        }
    }
    protected function can_access_this_estimate($estimate_id = 0, $check_client = false)
    {
        $permissions = $this->login_user->permissions;
        if($this->login_user->is_admin) {
            return true;
        }
        if(get_array_value($permissions, "estimate") == "all") {
            return true;
        }
        if(!$estimate_id && get_array_value($permissions, "estimate")) {
            return true;
        }
        if($estimate_id) {
            $estimate_info = $this->Estimates_model->get_one($estimate_id);
            if($check_client && $this->login_user->user_type == "client" && $estimate_info->client_id === $this->login_user->client_id) {
                return true;
            }
            if($estimate_info->id && get_array_value($permissions, "estimate") == "own" && $estimate_info->created_by == $this->login_user->id) {
                return true;
            }
        }
    }
    protected function is_invoice_editable($_invoice, $is_clone = 0)
    {
        if(get_setting("enable_invoice_lock_state")) {
            $invoice_info = is_object($_invoice) ? $_invoice : $this->Invoices_model->get_one($_invoice);
            if(!$invoice_info->id || $is_clone) {
                return true;
            }
            if($invoice_info->status == "draft") {
                return true;
            }
        } else {
            return true;
        }
    }
}

?>