<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 72.
namespace App\Controllers;

class Signin extends App_Controller
{
    private $signin_validation_errors;
    public function __construct()
    {
        parent::__construct();
        $this->signin_validation_errors = [];
        helper("email");
    }
    public function index()
    {
        if($this->Users_model->login_user_id()) {
            app_redirect("dashboard/view");
        } else {
            $view_data["redirect"] = "";
            if(isset($_REQUEST["redirect"])) {
                $view_data["redirect"] = $_REQUEST["redirect"];
            }
            return $this->template->view("signin/index", $view_data);
        }
    }
    private function has_recaptcha_error()
    {
        $recaptcha_post_data = $this->request->getPost("g-recaptcha-response");
        $response = $this->is_valid_recaptcha($recaptcha_post_data);
        if($response === true) {
            return true;
        }
        array_push($this->signin_validation_errors, app_lang("re_captcha_error-" . $response));
        return false;
    }
    private function is_valid_recaptcha($recaptcha_post_data)
    {
        require_once APPPATH . "ThirdParty/recaptcha/autoload.php";
        $recaptcha = new \ReCaptcha\ReCaptcha(get_setting("re_captcha_secret_key"));
        $resp = $recaptcha->verify($recaptcha_post_data, $_SERVER["REMOTE_ADDR"]);
        if($resp->isSuccess()) {
            return true;
        }
        $error = "";
        foreach ($resp->getErrorCodes() as $code) {
            $error = $code;
        }
        return $error;
    }
    public function authenticate()
    {
        $validation = $this->validate_submitted_data(["email" => "required|valid_email", "password" => "required"], true);
        $email = $this->request->getPost("email");
        $password = $this->request->getPost("password");
        if(!$email) {
            app_redirect("signin");
        }
        if(is_array($validation)) {
            $this->signin_validation_errors = $validation;
        }
        if(get_setting("re_captcha_secret_key")) {
            $this->has_recaptcha_error();
        }
        if($this->signin_validation_errors) {
            $this->session->setFlashdata("signin_validation_errors", $this->signin_validation_errors);
            app_redirect("signin");
        }
        if(!$this->Users_model->authenticate($email, $password)) {
            array_push($this->signin_validation_errors, app_lang("authentication_failed"));
            $this->session->setFlashdata("signin_validation_errors", $this->signin_validation_errors);
            app_redirect("signin");
        }
        $redirect = $this->request->getPost("redirect");
        if($redirect) {
            return redirect()->to($redirect);
        }
        app_redirect("dashboard/view");
    }
    public function sign_out()
    {
        $this->Users_model->sign_out();
    }
    public function send_reset_password_mail()
    {
        $this->validate_submitted_data(["email" => "required|valid_email"]);
        if(get_setting("re_captcha_secret_key")) {
            $response = $this->is_valid_recaptcha($this->request->getPost("g-recaptcha-response"));
            if($response !== true) {
                if($response) {
                    echo json_encode(["success" => false, "message" => app_lang("re_captcha_error-" . $response)]);
                } else {
                    echo json_encode(["success" => false, "message" => app_lang("re_captcha_expired")]);
                }
                return false;
            }
        }
        $email = $this->request->getPost("email");
        $existing_user = $this->Users_model->is_email_exists($email);
        if($existing_user) {
            $email_template = $this->Email_templates_model->get_final_template("reset_password", true);
            $user_language = $existing_user->language;
            $parser_data["ACCOUNT_HOLDER_NAME"] = $existing_user->first_name . " " . $existing_user->last_name;
            $parser_data["SIGNATURE"] = get_array_value($email_template, "signature_" . $user_language) ? get_array_value($email_template, "signature_" . $user_language) : get_array_value($email_template, "signature_default");
            $parser_data["LOGO_URL"] = get_logo_url();
            $parser_data["SITE_URL"] = get_uri();
            $parser_data["RECIPIENTS_EMAIL_ADDRESS"] = $existing_user->email;
            $verification_data = ["type" => "reset_password", "code" => make_random_string(), "params" => serialize(["email" => $existing_user->email, "expire_time" => time() + 86400])];
            $save_id = $this->Verification_model->ci_save($verification_data);
            $verification_info = $this->Verification_model->get_one($save_id);
            $parser_data["RESET_PASSWORD_URL"] = get_uri("signin/new_password/" . $verification_info->code);
            $message = get_array_value($email_template, "message_" . $user_language) ? get_array_value($email_template, "message_" . $user_language) : get_array_value($email_template, "message_default");
            $subject = get_array_value($email_template, "subject_" . $user_language) ? get_array_value($email_template, "subject_" . $user_language) : get_array_value($email_template, "subject_default");
            $message = $this->parser->setData($parser_data)->renderString($message);
            $subject = $this->parser->setData($parser_data)->renderString($subject);
            if(send_app_mail($email, $subject, $message)) {
                echo json_encode(["success" => true, "message" => app_lang("reset_info_send")]);
            } else {
                echo json_encode(["success" => false, "message" => app_lang("error_occurred")]);
            }
        } else {
            echo json_encode(["success" => false, "message" => app_lang("no_acount_found_with_this_email")]);
            return false;
        }
    }
    public function request_reset_password()
    {
        $view_data["form_type"] = "request_reset_password";
        return $this->template->view("signin/index", $view_data);
    }
    public function new_password($key)
    {
        $valid_key = $this->is_valid_reset_password_key($key);
        if($valid_key) {
            $email = get_array_value($valid_key, "email");
            if($this->Users_model->is_email_exists($email)) {
                $view_data["key"] = clean_data($key);
                $view_data["form_type"] = "new_password";
                return $this->template->view("signin/index", $view_data);
            }
        }
        $view_data["heading"] = "Invalid Request";
        $view_data["message"] = "The key has expaired or something went wrong!";
        return $this->template->view("errors/html/error_general", $view_data);
    }
    public function do_reset_password()
    {
        $this->validate_submitted_data(["key" => "required", "password" => "required"]);
        $key = $this->request->getPost("key");
        $password = $this->request->getPost("password");
        $valid_key = $this->is_valid_reset_password_key($key);
        if($valid_key) {
            $email = get_array_value($valid_key, "email");
            $this->Users_model->update_password($email, password_hash($password, PASSWORD_DEFAULT));
            $options = ["code" => $key, "type" => "reset_password"];
            $verification_info = $this->Verification_model->get_details($options)->getRow();
            if($verification_info->id) {
                $this->Verification_model->delete_permanently($verification_info->id);
            }
            echo json_encode(["success" => true, "message" => app_lang("password_reset_successfully") . " " . anchor("signin", app_lang("signin"))]);
            return true;
        }
        echo json_encode(["success" => false, "message" => app_lang("error_occurred")]);
    }
    private function is_valid_reset_password_key($verification_code = "")
    {
        if($verification_code) {
            $options = ["code" => $verification_code, "type" => "reset_password"];
            $verification_info = $this->Verification_model->get_details($options)->getRow();
            if($verification_info && $verification_info->id) {
                $reset_password_info = unserialize($verification_info->params);
                $email = get_array_value($reset_password_info, "email");
                $expire_time = get_array_value($reset_password_info, "expire_time");
                if($email && filter_var($email, FILTER_VALIDATE_EMAIL) && $expire_time && time() < $expire_time) {
                    return ["email" => $email];
                }
            }
        }
    }
}

?>