<?php echo form_open(get_uri("attendance/save"), array("id" => "attendance-form", "class" => "general-form", "role" => "form")); ?>
<div class="modal-body clearfix">
    <div class="container-fluid">
        <input type="hidden" name="id" value="<?php echo $model_info->id; ?>" />

        <div class="clearfix">
            <div class="form-group">
                <div class="row">
                    <label for="applicant_id" class=" col-md-3"><?php echo app_lang('team_member'); ?></label>
                    <div class=" col-md-9">
                        <?php
                        if (isset($team_members_info)) {
                            $image_url = get_avatar($team_members_info->image);
                            echo "<span class='avatar avatar-xs ml-10'><img src='$image_url' alt=''></span>" . $team_members_info->first_name . " " . $team_members_info->last_name;
                            ?>
                            <input type="hidden" name="user_id" value="<?php echo $team_members_info->id; ?>" />
                            <?php
                        } else {
                            echo form_dropdown("user_id", $team_members_dropdown, "", "class='select2 validate-hidden' id='attendance_user_id' data-rule-required='true', data-msg-required='" . app_lang('field_required') . "'");
                        }
                        ?>
                    </div>
                </div>
            </div>
            <div class="row">
                <label for="persian_in_date" class=" col-md-3 col-sm-3"><?php echo app_lang('in_date'); ?></label>
                <div class="col-md-4 col-sm-4 form-group">
                    <?php
                    $in_time = is_date_exists($model_info->in_time) ? convert_to_jalali($model_info->in_time, 'Y/m/j') : "";

                    if ($time_format_24_hours) {
                        $in_time_value = $in_time ? date("H:i", strtotime(($model_info->in_time) ? convert_date_utc_to_local($model_info->in_time) : "")) : "";
                    } else {
                        $in_time_value = $in_time ? convert_time_to_12hours_format(date("H:i:s", strtotime(($model_info->in_time) ? convert_date_utc_to_local($model_info->in_time) : ""))) : "";
                    }

                    echo form_input(array(
                        "id" => "persian_in_date",
                        "name" => "persian_in_date",
                        "value" => $in_time ? $in_time : "",
                        "class" => "form-control",
                        "placeholder" => app_lang('in_date'),
                        "autocomplete" => "off",
                        "data-rule-required" => true,
                        "data-msg-required" => app_lang("field_required"),
                    ));
                    ?>
                </div>
                <input id="in_date" name="in_date" type="hidden" class="form-control" value="<?php echo $in_time ? $in_time : ""; ?>">
                <label for="in_time" class=" col-md-2 col-sm-2"><?php echo app_lang('in_time'); ?></label>
                <div class=" col-md-3 col-sm-3  form-group">
                    <?php
                    echo form_input(array(
                        "id" => "in_time",
                        "name" => "in_time",
                        "value" => $in_time_value,
                        "class" => "form-control",
                        "placeholder" => app_lang('in_time'),
                        "data-rule-required" => true,
                        "data-msg-required" => app_lang("field_required"),
                    ));
                    ?>
                </div>
            </div>
        </div>

        <div class="clearfix">
            <div class="row">
                <label for="persian_out_date" class=" col-md-3 col-sm-3"><?php echo app_lang('out_date'); ?></label>
                <div class=" col-md-4 col-sm-4 form-group">
                    <?php
                    $out_time = is_date_exists($model_info->out_time) ? convert_to_jalali($model_info->out_time, 'Y/m/j') : "";

                    if ($time_format_24_hours) {
                        $out_time_value = $in_time ? date("H:i", strtotime(($model_info->out_time) ? convert_date_utc_to_local($model_info->out_time) : "")) : "";
                    } else {
                        $out_time_value = $in_time ? convert_time_to_12hours_format(date("H:i:s", strtotime(($model_info->out_time) ? convert_date_utc_to_local($model_info->out_time) : ""))) : "";
                    }

                    echo form_input(array(
                        "id" => "persian_out_date",
                        "name" => "persian_out_date",
                        "value" => $out_time ? $out_time : "",
                        "class" => "form-control",
                        "placeholder" => app_lang('out_date'),
                        "autocomplete" => "off",
                        "data-rule-required" => true,
                        "data-msg-required" => app_lang("field_required"),
                    ));
                    ?>
                </div>
                <input id="out_date" name="out_date" type="hidden" class="form-control" value="<?php echo $out_time ? $out_time : ""; ?>">
                <label for="out_time" class=" col-md-2 col-sm-2"><?php echo app_lang('out_time'); ?></label>
                <div class=" col-md-3 col-sm-3 form-group">
                    <?php
                    echo form_input(array(
                        "id" => "out_time",
                        "name" => "out_time",
                        "value" => $out_time_value,
                        "class" => "form-control",
                        "placeholder" => app_lang('out_time'),
                        "data-rule-required" => true,
                        "data-msg-required" => app_lang("field_required"),
                    ));
                    ?>
                </div>
            </div>
        </div>
        <div class="form-group">
            <div class="row">
                <label for="note" class=" col-md-3"><?php echo app_lang('note'); ?></label>
                <div class=" col-md-9">
                    <?php
                    echo form_textarea(array(
                        "id" => "note",
                        "name" => "note",
                        "class" => "form-control",
                        "placeholder" => app_lang('note'),
                        "value" => process_images_from_content($model_info->note, false),
                        "data-rich-text-editor" => true
                    ));
                    ?>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal-footer">
    <button type="button" class="btn btn-default" data-bs-dismiss="modal"><span data-feather="x" class="icon-16"></span> <?php echo app_lang('close'); ?></button>
    <button type="submit" class="btn btn-primary"><span data-feather="check-circle" class="icon-16"></span> <?php echo app_lang('save'); ?></button>
</div>
<?php echo form_close(); ?>

<script type="text/javascript">
    $(document).ready(function () {
        $("#attendance-form").appForm({
            onSuccess: function (result) {
                $(".dataTable:visible").appTable({newData: result.data, dataId: result.id});
            }
        });
        if ($("#attendance_user_id").length) {
            $("#attendance_user_id").select2();
        }
        $('#persian_in_date').persianDatepicker({
            altField: '#in_date',
            altFormat: 'YYYY/MM/DD',
            calendarType: 'persian',
            initialValue: false,
            observer: false,
            format: 'YYYY/MM/DD',
            timePicker: {
                enabled: false
            },
            position:'auto',
            'autoClose':true,
			calendar: {
                persian: {
                    showHint: true
                },
                gregorian: {
                    showHint: true
                }
            },
        });
         $('#persian_out_date').persianDatepicker({
            altField: '#out_date',
            altFormat: 'YYYY/MM/DD',
            calendarType: 'persian',
            initialValue: false,
            observer: false,
            format: 'YYYY/MM/DD',
            timePicker: {
                enabled: false
            },
            position:'auto',
            'autoClose':true,
			calendar: {
                persian: {
                    showHint: true
                },
                gregorian: {
                    showHint: true
                }
            },
        });

        setTimePicker("#in_time, #out_time");
        setTimeout(function () {
            $("#name").focus();
        }, 200);
    });
</script>